/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.patch;

import info.msxlaunchers.openmsx.common.HashUtils;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.patch.AbstractPatcher;
import info.msxlaunchers.openmsx.launcher.patch.PatchException;
import info.msxlaunchers.openmsx.launcher.patch.PatchExceptionIssue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;

final class IPSPatcher
extends AbstractPatcher {
    private final int MINIMUM_IPS_SIZE = 8;
    private final int MAXIMUM_IPS_SIZE = 0x1000000;
    private final int MAXIMUM_SOURCE_SIZE = 0x1000000;
    private final byte[] PATCH_HEADER = "PATCH".getBytes();
    private final int RECORD_OFFSET_BYTE_COUNT = 3;
    private final int RECORD_SIZE_BYTE_COUNT = 2;
    private final int RECORD_RLE_SIZE_BYTE_COUNT = 2;
    private final int IPS_TRUNCATE_BYTE_COUNT = 3;
    private final byte[] PATCH_EOF = "EOF".getBytes();

    IPSPatcher() {
    }

    @Override
    protected void performValidation(Path fileToPatch, Path patchFile, boolean skipCheckcum, String checksum) throws PatchException {
        this.validateFileSize(fileToPatch, 0, 0x1000000, PatchExceptionIssue.FILE_TO_PATCH_NOT_PATCHABLE);
        this.validateFileSize(patchFile, 8, 0x1000000, PatchExceptionIssue.INVALID_PATCH_FILE);
        this.verifyChecksumIfRequested(fileToPatch, skipCheckcum, checksum);
    }

    @Override
    protected void patchFileData(Path fileToPatch, Path patchFile, Path targetFile, boolean skipChecksumValidation) throws PatchException {
        int targetROMTruncatedSize;
        byte[] fileToPatchData = this.readFileData(fileToPatch);
        byte[] patchFileData = this.readFileData(patchFile);
        if (!this.isByteSequenceEqualToString(patchFileData, 0, this.PATCH_HEADER)) {
            throw new PatchException(PatchExceptionIssue.INVALID_PATCH_FILE);
        }
        boolean done = false;
        int ipsFileDataIndex = this.PATCH_HEADER.length;
        byte[] patchedBuffer = new byte[fileToPatchData.length];
        System.arraycopy(fileToPatchData, 0, patchedBuffer, 0, fileToPatchData.length);
        while (!done) {
            if (this.isByteSequenceEqualToString(patchFileData, ipsFileDataIndex, this.PATCH_EOF)) {
                ipsFileDataIndex += this.PATCH_EOF.length;
                done = true;
                continue;
            }
            int recordOffsetValue = this.byte3ToInt(patchFileData, ipsFileDataIndex);
            int recordSizeValue = this.byte2ToInt(patchFileData, ipsFileDataIndex += 3);
            ipsFileDataIndex += 2;
            if (recordSizeValue == 0) {
                int rleSizeValue = this.byte2ToInt(patchFileData, ipsFileDataIndex);
                int offsetDataSize = recordOffsetValue + rleSizeValue;
                if (offsetDataSize > fileToPatchData.length) {
                    patchedBuffer = this.resizeBuffer(patchedBuffer, offsetDataSize);
                }
                Arrays.fill(patchedBuffer, recordOffsetValue, recordOffsetValue + rleSizeValue, patchFileData[ipsFileDataIndex += 2]);
                ++ipsFileDataIndex;
                continue;
            }
            int offsetDataSize = recordOffsetValue + recordSizeValue;
            if (offsetDataSize > fileToPatchData.length) {
                patchedBuffer = this.resizeBuffer(patchedBuffer, offsetDataSize);
            }
            this.validateArraySize(patchFileData, ipsFileDataIndex, recordSizeValue);
            System.arraycopy(patchFileData, ipsFileDataIndex, patchedBuffer, recordOffsetValue, recordSizeValue);
            ipsFileDataIndex += recordSizeValue;
        }
        int truncateDataLength = patchFileData.length - ipsFileDataIndex;
        if (truncateDataLength == 3 && (targetROMTruncatedSize = this.byte3ToInt(patchFileData, ipsFileDataIndex)) > 0 && targetROMTruncatedSize < fileToPatchData.length) {
            patchedBuffer = this.resizeBuffer(patchedBuffer, targetROMTruncatedSize);
        }
        this.savePatchedData(patchedBuffer, fileToPatch, targetFile);
    }

    private byte[] readFileData(Path file) throws PatchException {
        try {
            return Files.readAllBytes(file);
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new PatchException(PatchExceptionIssue.IO);
        }
    }

    private byte[] resizeBuffer(byte[] buffer, int size) {
        byte[] tempBuffer = new byte[size];
        System.arraycopy(buffer, 0, tempBuffer, 0, Math.min(buffer.length, size));
        return tempBuffer;
    }

    private int byte3ToInt(byte[] data, int index) throws PatchException {
        this.validateArraySize(data, index, 3);
        return data[index] << 16 & 0xFF0000 | data[index + 1] << 8 & 0xFF00 | data[index + 2] & 0xFF;
    }

    private int byte2ToInt(byte[] data, int index) throws PatchException {
        this.validateArraySize(data, index, 2);
        return data[index] << 8 & 0xFF00 | data[index + 1] & 0xFF;
    }

    private void validateArraySize(byte[] data, int index, int length) throws PatchException {
        if (index + length > data.length) {
            throw new PatchException(PatchExceptionIssue.INVALID_PATCH_FILE);
        }
    }

    private void verifyChecksumIfRequested(Path fileToPatch, boolean skipCheckcum, String checksum) throws PatchException {
        if (!skipCheckcum && checksum != null) {
            String crc32Code;
            String md5Sum;
            String trimmedChecksum = checksum.trim();
            String sha1Code = HashUtils.getSHA1Code(fileToPatch.toFile());
            if (!(sha1Code.equalsIgnoreCase(trimmedChecksum) || (md5Sum = HashUtils.getMD5Sum(fileToPatch.toFile())).equalsIgnoreCase(trimmedChecksum) || (crc32Code = HashUtils.getCRC32Code(fileToPatch.toFile())).equalsIgnoreCase(trimmedChecksum))) {
                throw new PatchException(PatchExceptionIssue.SOURCE_FILE_CHECKSUM_NOT_MATCH);
            }
        }
    }

    private void savePatchedData(byte[] patchedFileData, Path fileToPatch, Path targetFile) throws PatchException {
        Path fileToWrite = targetFile == null ? fileToPatch : targetFile;
        try {
            Files.write(fileToWrite, patchedFileData, new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new PatchException(PatchExceptionIssue.TARGET_FILE_CANNOT_WRITE);
        }
    }
}

